/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         // insert code to be run when the composition is fully loaded here
         
         // make an array of the draggable symbol names
            var numbers = ['num1','num2','num3','num4','num5','num6'];
            // make an array of the droppable element names
            var targets = ['home1','home2','home3','home4','home5','home6'];
            // have only the first element be draggable
         
         var Pos = [
         {'x':144,'y':407},
         {'x':206,'y':407},
         {'x':274,'y':407},
         {'x':345,'y':407},
         {'x':408,'y':407},
         {'x':474,'y':407}
         
            ];
         
         k=0;
         
         
            // set up the droppable to accept each draggables
            for (i=0;i<numbers.length;i++){	
            	sym.$(numbers[i]).css({"left":Pos[i].x,"top":Pos[i].y,"position":"absolute"})
            	sym.$(numbers[i]).addClass('C'+i);
            	sym.$('.C'+i).draggable({
            	revert: 'invalid', opacity:1,
            	   	});
         
         
         
            sym.$(targets[i]).droppable({
            		accept:'.C'+i,   // use class for accept
            		drop: handleDropEvent
         
            	});
         
         
            }
         
         
         function handleDropEvent(event, ui){		
                ui.draggable.draggable( 'disable' );
                $(this).droppable( 'disable' );
                // place draggable where needed. could be left, top
               // ui.draggable.position( { of: $(this), my: 'left', at: 'top' } );
                ui.draggable.position( { of: $(this), my: 'center', at: 'middle' } );
                ui.draggable.draggable( 'option', 'revert', false );
         
         
               var p = ui.draggable.attr("id");
         
               k++;
         
         		playsound(p);
         		checkAnimation();
         
         
            }
         
         
         function checkAnimation(){
         	if (k==6){
         
         
          		  sym.getSymbol("Symbol_1").play();
          		  sym.$("welldonesound13")[0].play();
          		  setTimeout(function(){sym.$("btn_reset2").show();}, 5000);
         
         
         	}
         
         }
         
         
         
         	function playsound(r){
         
           if(r=='Stage_num1'){
         
         			sym.$("Soundwake")[0].currentTime = 0;
         		if (sym.$("Soundwake")[0].paused) 
         				{
         				sym.$("Soundwake")[0].play();
         				}
         
         			}
         
              if(r=='Stage_num2'){
         
         			sym.$("Soundteeth")[0].currentTime = 0;
         			if (sym.$("Soundteeth")[0].paused) 
         			{
         			sym.$("Soundteeth")[0].play();
         			}
         		}
         
         		if(r=='Stage_num3'){
         
         			sym.$("lowshower")[0].currentTime = 0;
         			if (sym.$("lowshower")[0].paused) 
         			{
         			sym.$("lowshower")[0].play();
         			}
         		}
         
         
         		if(r=='Stage_num4'){
         
         			sym.$("Sounddry")[0].currentTime = 0;
         			if (sym.$("Sounddry")[0].paused) 
         			{
         			sym.$("Sounddry")[0].play();
         			}
         		}
         
         		if(r=='Stage_num5'){
         
         			sym.$("Soundclothes")[0].currentTime = 0;
         		if (sym.$("Soundclothes")[0].paused) 
         				{
         				sym.$("Soundclothes")[0].play();
         				}
         			}
         
         			if(r=='Stage_num6'){
         
         			sym.$("Soundready")[0].currentTime = 0;
         		if (sym.$("Soundready")[0].paused) 
         				{
         				sym.$("Soundready")[0].play();
         				}
         			}
         
         
         
         
         
         
         		}
         
         //sym.$('btn_reset1').click(function(){
            	//window.location.reload()
            //});

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${btn_reset2}", "click", function(sym, e) {
         
         
         
         
         
         location.reload('true');

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${Stage}", "touchstart", function(sym, e) {
         // insert code to be run when a user touches the object (for touch devices only)
           // set up the droppable to accept each draggables
            for (i=0;i<numbers.length;i++){	
            	sym.$(numbers[i]).css({"left":Pos[i].x,"top":Pos[i].y,"position":"absolute"})
            	sym.$(numbers[i]).addClass('C'+i);
            	sym.$('.C'+i).draggable({
            	revert: 'invalid', opacity:1,
            	   	});
         
         
         
            sym.$(targets[i]).droppable({
            		accept:'.C'+i,   // use class for accept
            		drop: handleDropEvent
         
            	});
         
         
            }
         
         
         function handleDropEvent(event, ui){		
                ui.draggable.draggable( 'disable' );
                $(this).droppable( 'disable' );
                // place draggable where needed. could be left, top
               // ui.draggable.position( { of: $(this), my: 'left', at: 'top' } );
                ui.draggable.position( { of: $(this), my: 'center', at: 'middle' } );
                ui.draggable.draggable( 'option', 'revert', false );
         
         
               var p = ui.draggable.attr("id");
         
               k++;
         
         		playsound(p);
         		checkAnimation();
         
         
            }
         
         
         function checkAnimation(){
         	if (k==6){
         
         
          		  sym.getSymbol("Symbol_1").play();
          		  sym.$("welldonesound13")[0].play();
          		  setTimeout(function(){sym.$("btn_reset2").show();}, 5000);
         
         
         	}
         
         }
         
         
         
         	function playsound(r){
         
           if(r=='Stage_num1'){
         
         			sym.$("Soundwake")[0].currentTime = 0;
         		if (sym.$("Soundwake")[0].paused) 
         				{
         				sym.$("Soundwake")[0].play();
         				}
         
         			}
         
              if(r=='Stage_num2'){
         
         			sym.$("Soundteeth")[0].currentTime = 0;
         			if (sym.$("Soundteeth")[0].paused) 
         			{
         			sym.$("Soundteeth")[0].play();
         			}
         		}
         
         		if(r=='Stage_num3'){
         
         			sym.$("lowshower")[0].currentTime = 0;
         			if (sym.$("lowshower")[0].paused) 
         			{
         			sym.$("lowshower")[0].play();
         			}
         		}
         
         
         		if(r=='Stage_num4'){
         
         			sym.$("Sounddry")[0].currentTime = 0;
         			if (sym.$("Sounddry")[0].paused) 
         			{
         			sym.$("Sounddry")[0].play();
         			}
         		}
         
         		if(r=='Stage_num5'){
         
         			sym.$("Soundclothes")[0].currentTime = 0;
         		if (sym.$("Soundclothes")[0].paused) 
         				{
         				sym.$("Soundclothes")[0].play();
         				}
         			}
         
         			if(r=='Stage_num6'){
         
         			sym.$("Soundready")[0].currentTime = 0;
         		if (sym.$("Soundready")[0].paused) 
         				{
         				sym.$("Soundready")[0].play();
         				}
         			}
         
         
         
         
         
         
         		}

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'btn_reset2'
   (function(symbolName) {   
   
   })("btn_reset2");
   //Edge symbol end:'btn_reset2'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-3598328");